/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.evolvedmekanism.jei;

import fr.iglee42.evolvedmekanism.EvolvedMekanism;
import fr.iglee42.evolvedmekanism.jei.categories.APTRecipeCategory;
import fr.iglee42.evolvedmekanism.jei.categories.AlloyerRecipeCategory;
import fr.iglee42.evolvedmekanism.jei.categories.ChemixerRecipeCategory;
import fr.iglee42.evolvedmekanism.recipes.AlloyerRecipe;
import fr.iglee42.evolvedmekanism.recipes.ChemixerRecipe;
import fr.iglee42.evolvedmekanism.registries.EMBlocks;
import fr.iglee42.evolvedmekanism.registries.EMItems;
import fr.iglee42.evolvedmekanism.registries.EMRecipeType;
import java.util.List;
import java.util.Optional;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.energy.IStrictEnergyHandler;
import mekanism.api.math.FloatingLong;
import mekanism.api.providers.IItemProvider;
import mekanism.api.recipes.ItemStackGasToItemStackRecipe;
import mekanism.client.jei.CatalystRegistryHelper;
import mekanism.client.jei.MekanismJEIRecipeType;
import mekanism.client.jei.RecipeRegistryHelper;
import mekanism.common.capabilities.Capabilities;
import mekanism.common.util.RegistryUtils;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.subtypes.IIngredientSubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IModIngredientRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import mezz.jei.api.registration.ISubtypeRegistration;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;

@JeiPlugin
public class EMJEI
implements IModPlugin {
    public static final MekanismJEIRecipeType<AlloyerRecipe> ALLOYING = new MekanismJEIRecipeType(EMBlocks.ALLOYER, AlloyerRecipe.class);
    public static final MekanismJEIRecipeType<ChemixerRecipe> CHEMIXING = new MekanismJEIRecipeType(EMBlocks.CHEMIXER, ChemixerRecipe.class);
    public static final MekanismJEIRecipeType<ItemStackGasToItemStackRecipe> APT = new MekanismJEIRecipeType(EMItems.BETTER_GOLD_INGOT, ItemStackGasToItemStackRecipe.class);
    private static final IIngredientSubtypeInterpreter<ItemStack> MEKANISM_NBT_INTERPRETER = (stack, context) -> {
        if (context == UidContext.Ingredient && stack.m_41782_()) {
            String nbtRepresentation = EMJEI.getChemicalComponent(stack, Capabilities.GAS_HANDLER);
            nbtRepresentation = EMJEI.addInterpretation(nbtRepresentation, EMJEI.getChemicalComponent(stack, Capabilities.INFUSION_HANDLER));
            nbtRepresentation = EMJEI.addInterpretation(nbtRepresentation, EMJEI.getChemicalComponent(stack, Capabilities.PIGMENT_HANDLER));
            nbtRepresentation = EMJEI.addInterpretation(nbtRepresentation, EMJEI.getChemicalComponent(stack, Capabilities.SLURRY_HANDLER));
            nbtRepresentation = EMJEI.addInterpretation(nbtRepresentation, EMJEI.getFluidComponent(stack));
            nbtRepresentation = EMJEI.addInterpretation(nbtRepresentation, EMJEI.getEnergyComponent(stack));
            return nbtRepresentation;
        }
        return "";
    };

    private static String addInterpretation(String nbtRepresentation, String component) {
        return nbtRepresentation.isEmpty() ? component : nbtRepresentation + ":" + component;
    }

    private static String getChemicalComponent(ItemStack stack, Capability<? extends IChemicalHandler<?, ?>> capability) {
        Optional cap = stack.getCapability(capability).resolve();
        if (cap.isPresent()) {
            IChemicalHandler handler = (IChemicalHandler)cap.get();
            String component = "";
            int tanks = handler.getTanks();
            for (int tank = 0; tank < tanks; ++tank) {
                ChemicalStack chemicalStack = handler.getChemicalInTank(tank);
                if (!chemicalStack.isEmpty()) {
                    component = EMJEI.addInterpretation(component, chemicalStack.getTypeRegistryName().toString());
                    continue;
                }
                if (tanks <= 1) continue;
                component = EMJEI.addInterpretation(component, "empty");
            }
            return component;
        }
        return "";
    }

    private static String getFluidComponent(ItemStack stack) {
        Optional cap = FluidUtil.getFluidHandler((ItemStack)stack).resolve();
        if (cap.isPresent()) {
            IFluidHandlerItem handler = (IFluidHandlerItem)cap.get();
            String component = "";
            int tanks = handler.getTanks();
            for (int tank = 0; tank < tanks; ++tank) {
                FluidStack fluidStack = handler.getFluidInTank(tank);
                if (!fluidStack.isEmpty()) {
                    component = EMJEI.addInterpretation(component, RegistryUtils.getName((Fluid)fluidStack.getFluid()).toString());
                    continue;
                }
                if (tanks <= 1) continue;
                component = EMJEI.addInterpretation(component, "empty");
            }
            return component;
        }
        return "";
    }

    private static String getEnergyComponent(ItemStack stack) {
        Optional capability = stack.getCapability(Capabilities.STRICT_ENERGY).resolve();
        if (capability.isPresent()) {
            IStrictEnergyHandler energyHandlerItem = (IStrictEnergyHandler)capability.get();
            String component = "";
            int containers = energyHandlerItem.getEnergyContainerCount();
            for (int container = 0; container < containers; ++container) {
                FloatingLong neededEnergy = energyHandlerItem.getNeededEnergy(container);
                if (neededEnergy.isZero()) {
                    component = EMJEI.addInterpretation(component, "filled");
                    continue;
                }
                if (containers <= 1) continue;
                component = EMJEI.addInterpretation(component, "empty");
            }
            return component;
        }
        return "";
    }

    @NotNull
    public ResourceLocation getPluginUid() {
        return EvolvedMekanism.rl("jei_plugin");
    }

    public static void registerItemSubtypes(ISubtypeRegistration registry, List<? extends IItemProvider> itemProviders) {
        for (IItemProvider iItemProvider : itemProviders) {
            ItemStack itemStack = iItemProvider.getItemStack();
            if (!itemStack.getCapability(Capabilities.STRICT_ENERGY).isPresent() && !itemStack.getCapability(Capabilities.GAS_HANDLER).isPresent() && !itemStack.getCapability(Capabilities.INFUSION_HANDLER).isPresent() && !itemStack.getCapability(Capabilities.PIGMENT_HANDLER).isPresent() && !itemStack.getCapability(Capabilities.SLURRY_HANDLER).isPresent() && !FluidUtil.getFluidHandler((ItemStack)itemStack).isPresent()) continue;
            registry.registerSubtypeInterpreter(VanillaTypes.ITEM_STACK, (Object)iItemProvider.m_5456_(), MEKANISM_NBT_INTERPRETER);
        }
    }

    public void registerItemSubtypes(ISubtypeRegistration registry) {
        EMJEI.registerItemSubtypes(registry, EMItems.ITEMS.getAllItems());
        EMJEI.registerItemSubtypes(registry, EMBlocks.BLOCKS.getAllBlocks());
    }

    public void registerIngredients(IModIngredientRegistration registry) {
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        IGuiHelper guiHelper = registry.getJeiHelpers().getGuiHelper();
        registry.addRecipeCategories(new IRecipeCategory[]{new AlloyerRecipeCategory(guiHelper, ALLOYING)});
        registry.addRecipeCategories(new IRecipeCategory[]{new ChemixerRecipeCategory(guiHelper, CHEMIXING)});
        registry.addRecipeCategories(new IRecipeCategory[]{new APTRecipeCategory(guiHelper, APT)});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registry) {
    }

    public void registerRecipes(IRecipeRegistration registry) {
        RecipeRegistryHelper.register((IRecipeRegistration)registry, ALLOYING, EMRecipeType.ALLOYING);
        RecipeRegistryHelper.register((IRecipeRegistration)registry, CHEMIXING, EMRecipeType.CHEMIXING);
        RecipeRegistryHelper.register((IRecipeRegistration)registry, APT, EMRecipeType.APT);
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registry) {
        CatalystRegistryHelper.register((IRecipeCatalystRegistration)registry, EMBlocks.ALLOYER, (MekanismJEIRecipeType[])new MekanismJEIRecipeType[0]);
        CatalystRegistryHelper.register((IRecipeCatalystRegistration)registry, EMBlocks.CHEMIXER, (MekanismJEIRecipeType[])new MekanismJEIRecipeType[0]);
        CatalystRegistryHelper.register((IRecipeCatalystRegistration)registry, APT, (IItemProvider[])new IItemProvider[]{EMBlocks.APT_CASING, EMBlocks.APT_PORT});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registry) {
    }
}

